import { apiEndpoints } from "@/src/constants/Endpoints";
import { ApiPaginationResult } from "@/src/types/general";
import { httpService } from "../httpService";
import { ApiPost } from "./types";

const { post } = apiEndpoints;

export const getPostDetailService = (PostId: string): Promise<ApiPost> =>
  httpService.get(`${post.detail}${PostId}`);
export const getPostsService = (params: {
  post_category_id?: string;
  title?: string;
  paginate: number;
  page: number;
}): Promise<ApiPaginationResult<ApiPost>> =>
  httpService.get(`${post.base}`, { params });
