import { ApiProduct } from "../../FoodServices/types";
import { ApiBranch } from "../../ChefService/types";

interface HomePageItem {
  name: string;
  value: string;
}
export interface ApiHomePage {
  home_fixed_image: [HomePageItem];
  home_discount_section: [HomePageItem];
  home_vendor_section: [HomePageItem];
  home_food_section: [HomePageItem];
  home_about_section: [HomePageItem];
  home_steps_section: [HomePageItem];
  home_register_vendor_section: [HomePageItem];
  home_features_section: [HomePageItem];
}
export interface HomePage {
  chefRegistration: {
    title: string;
    image: string;
    description: string;
    btnText: string;
  };
}
export interface ApiSlider {
  title: string;
  link: string;
  image: string;
  product: ApiProduct;
}
export type SliderType = "chef_search" | "home" | "product_search";
export interface ApiPageItem {
  title: string;
  slug: string;
}
export interface ApiPage extends ApiPageItem {
  text: string;
  cover: string | null;
}
export interface ApiSettings {
  emptyProductImage: string;
  title: string;
  meta: string;
  smDescription: string;
  keywords: string;
  scripts: string;
  logo: string;
  faveIcon: string;
  enamadCode: string;
  eata: string;
  sorosh: string;
  instagram: string;
  telegram: string;
  whatsapp: string;
  headerTelephoneSupport: string;
  headerTextSupport: string;
  systemMode: "multiVendor" | "single";
  branchSingleModeId?: string;
  mapAddress: "show" | "notShow";
  linkRule: string;
  "google-site-verification": string;
  backgroundPage: string;
  loader: string;
}
export interface ApiHomeItem {
  title: string;
  restaurants: {
    data: ApiBranch[];
  };
}
export enum ApiComponentVariants {
  DISCOUNT_ONE = "DiscountProductType1",
  DISCOUNT_TWO = "DiscountProductType2",

  PRODUCT_ONE = "ProductSliderType1",
  PRODUCT_TWO = "ProductSliderType2",
  PRODUCT_THREE = "ProductSliderType3",
  SELLER_ONE = "SellerSliderType1",

  SINGLE_BANNER = "SingleBanner",
  DOUBLE_BANNER = "DoubleBanner",
  TRIPLE_BANNER = "TripleBanner",
  QUADRUPLE_BANNER = "FourthBanner",
  QUINTUPLE_BANNER = "FiveBanner",
  HEXTUPLE_BANNER = "SixBanner",

  SINGLE_SLIDER = "SingleSlider",
  DOUBLE_SLIDER = "DoubleSlider",
  TRIPPLE_SLIDER = "TripleSlider",

  QUADRUPLE_SLIDER = "FourthSlider",
  QUINTUPLE_SLIDER = "FiveSlider",
  HEXTUPLE_SLIDER = "SixSlider",
  REGISTRATION = "RegisterSeller1",
}
export type ApiComponentsType =
  (typeof ApiComponentVariants)[keyof typeof ApiComponentVariants];
export interface ApiComponentExtraData {
  image: string;
  title: string;
  link_more: string;
  btn_text_more: string;
  background_color: string;
  text: string;
  sub_description: string;
  btn_text: string;
  link: string;
  images: {
    image: string;
    title: string;
    link: string;
  }[];
}
export interface ApiComponents {
  name_component: ApiComponentsType;
  code: string;
  slug: string;
  is_request: boolean;
  extra: ApiComponentExtraData;
}
