import { ApiTimeStampData } from "@/src/types/general";

export interface ApiBaseTicket {
  text: string;
  subject: string;
  category_id: string;
  file?: string;
}
export interface ApiTicketCategory {
  id: string;
  title: string;
}
export enum ApiTicketStatusVariant {
  OPEN = "opened",
  CLOSED = "closed",
  WAITING = "waiting _answer",
}
export type ApiTicketStatusType =
  (typeof ApiTicketStatusVariant)[keyof typeof ApiTicketStatusVariant];
export interface ApiTicketItem extends ApiTimeStampData, ApiBaseTicket {
  id: string;
  status: ApiTicketStatusType;
  user_id: string;
  parent_id: string;
  category: ApiTicketCategory;
  user?: {
    id: string;
    name: string;
    family: string;
  };
  child?: ApiTicketItem[];
}
export interface ApiTicketParams {
  paginate: number;
  page: number;
}
