import { ApiTimeStampData } from "@/src/types/general";

export enum ApiTransactionVariant {
  CHARGE = "charge",
  ORDER = "pay_order",
  SALES = "sales",
  SALES_PROFIT = "sales_profit",
  DELIVER_PROFIT = "deliver_profit",
  DELIVER = "deliver",
}
export type ApiTransactionType =
  (typeof ApiTransactionVariant)[keyof typeof ApiTransactionVariant];

export interface ApiTransactionItem extends ApiTimeStampData {
  id: string;
  user_id: string;
  amount: number;
  transaction_type: ApiTransactionType;
  target_id: number;
  description: string;
}
