import { apiEndpoints } from "@/src/constants/Endpoints";
import { generateAuthenticatedServiceToken } from "@/src/utils/Helpers";
import { httpService } from "../httpService";
import { ApiUploadFile } from "./types";

const { upload } = apiEndpoints;

export const uploadFileService = (
  data: ApiUploadFile,
  token?: string
): Promise<string> =>
  httpService.post(
    upload.base,
    data,
    generateAuthenticatedServiceToken(token, "multipart/form-data")
  );
