import { createStore } from "zustand/vanilla";
import { Settings, SettingsStore } from "../types/general";

export const initialSettings: Settings = {
  eata: "",
  enamadCode: "",
  headerTelephoneSupport: "",
  instagram: "",
  headerTextSupport: "",
  logo: "",
  mode: "multiVendor",
  scripts: "",
  privacyRoute: "#",
  sorosh: "",
  telegram: "",
  whatsapp: "",
  forceMap: false,
  smDescription: "",
  title: "",
  singleModeBranch: "",
  authBg: "#ffffff",
  loader: "",
};

const createSettingsStore = (initState: Settings = initialSettings) =>
  createStore<SettingsStore>()((set) => ({
    settings: initState,

    setSettings: (settings: Settings) =>
      set((state) => ({
        settings: {
          ...state.settings,
          ...settings,
        },
      })),

    resetSettings: () =>
      set(() => ({
        settings: initialSettings,
      })),
  }));

export default createSettingsStore;
