import { create } from "zustand";
import { AuthUser } from "../types/auth";

const initialAuthUser: AuthUser = {
  name: "",
  family: "",
  mobile: "",
  email: "",
  phone: "",
};

interface AuthStore {
  authUser: AuthUser;
  setAuthUser: (user: AuthUser) => void;
  resetAuthUser: () => void;
}

const useAuthStore = create<AuthStore>()((set) => ({
  authUser: initialAuthUser,

  setAuthUser: (user: AuthUser) =>
    set((state) => ({
      authUser: {
        ...state.authUser,
        ...user,
      },
    })),

  resetAuthUser: () =>
    set(() => ({
      authUser: initialAuthUser,
    })),
}));

export default useAuthStore;
