import { Address } from "./Address";
import { BaseFood, Variety } from "./food";
import { OrderItems } from "./general";

export interface CartItem {
  food: Omit<BaseFood, "rate" | "image" | "Summary" | "varieties">;
  variety: Variety;
  count: number;
}
export interface Pricing {
  total: number;
  minOrder?: number;
  orderTotal: number;
  tax: number;
  sendPrice: number;
  PackPrice: number;
  discountedPrice: number;
  cashBack: number;
    subtotal?: number;
  delivery?: number;
 
}
export interface OrderCart extends CartItem {
  id: string;
}
export interface DeliveryType {
  id: string;
  title: string;
  isCost: boolean;
  isAddress: boolean;
  descriptionText: string;
  descriptionRequired: boolean;
  descriptionErrorMsg: string;
  isActive: boolean;
  message: string;
}
export interface Order {
  id: string;
  cart: OrderCart[];
  pricing: Pricing;
  chef: {
    id: string;
    name: string;
  };
  address?: Address;
  date?: string;
  status?: OrderItems;
  gatewayCode?: string;
  hasComment?: boolean;
  deliveryType?: DeliveryType;
}
export interface Gateway {
  id: number;
  title: string;
  isActive: boolean;
}

export interface Payment {
  code: string;
}
export interface DeliveryTime {
  day: string;
  time: string;
}

export interface Discount {
  code: string;
  title: string;
  chefTitle: string;
  maxOrderPrice: number;
  minOrderPrice: number;
  expireDate: Date;
  percent: number;
}
