class PersianDate extends Date {
  toLocaleDateString = (
    lang?: string,
    options?: Intl.DateTimeFormatOptions | undefined
  ) => super.toLocaleDateString(lang ?? "fa-IR-u-nu-latn", options);

  getParts = () => this.toLocaleDateString().split("/");

  getDay = () => (super.getDay() === 6 ? 0 : super.getDay() + 1);

  getDate = () => +this.getParts()[2];

  getYear = () => +this.getParts()[0];

  getMonth = () => +this.getParts()[1];

  getMonthName = () => this.toLocaleDateString("fa-IR", { month: "long" });

  getDayName = () => this.toLocaleDateString("fa-IR", { weekday: "long" });
}
export default new PersianDate();

export function getTehranTimeHHMMSS(): string {
  const parts = new Intl.DateTimeFormat("en-US", {
    timeZone: "Asia/Tehran",
    hour: "2-digit",
    minute: "2-digit",
    hour12: false,
  }).formatToParts(new Date());

  const hour = parts.find((p) => p.type === "hour")?.value ?? "00";
  const minute = parts.find((p) => p.type === "minute")?.value ?? "00";

  return `${hour.padStart(2, "0")}:${minute.padStart(2, "0")}:00`;
}
