"use server";

import {
  getAddressFromLocationService,
  getLocationFromAddressService,
} from "../services/httpServices/MapServices";
import { NeshanAddress } from "../types/map";

export async function getAddressFromLocation(
  lat: string,
  lng: string
): Promise<NeshanAddress> {
  const address = await getAddressFromLocationService(lat, lng);
  console.log("🚀 ~ getAddressFromLocation ~ address:", address)
  return {
    formattedAddress: address.data.formatted_address,
  };
}
export async function getLocationFromAddressFromLocation(term: string) {
  const address = await getLocationFromAddressService(term);
  const moddeldAddress = address.data.items.map((item) => ({
    value: item.title,
    label: `${item.region}- ${item.title} - ${item.address}`,
    location: item.location,
  }));
  return moddeldAddress;
}
