"use client";

import React from "react";
import Image from "next/image";
import Link from "next/link";
import { useSettingsStore } from "@/src/providers/SettingsProvider";

interface Props {
  width: number;
  height: number;
  className?: string;
}

function Logo({ height = 30, width = 100, className }: Props) {
  const { logo, title } = useSettingsStore((state) => state.settings);

  return (
    <Link href="/">
      <div className="flex  items-center justify-center">
        <Image
          alt={title}
          src={logo ?? ""}
          width={width}
          height={height}
          className={className}
        />
      </div>
    </Link>
  );
}

export { Logo };
