import React, { useState } from "react";
import { SearchNormal1 } from "iconsax-react";
import Button from "../Button";

interface Props {
  onSearch: (value: string) => void;
}

function SearchFelid({ onSearch }: Props) {
  const [searchMenuOpen, setSearchMenuOpen] = useState(false);

  return (
    <div className=" flex h-max w-full rounded-half   shadow-base    ">
      <div className="flex w-full">
        <span className=" flex items-center justify-center bg-primary pr-1">
          <SearchNormal1 variant="Broken" size="16" className="text-primary" />
        </span>
        <input
          onChange={(e) => onSearch(e.target.value)}
          type="text"
          className="w-full bg-primary p-1 text-h3 text-white outline-none lg:p-2"
          placeholder="جستجو کنید ..."
        />
      </div>
      <div className=" relative hidden flex-col items-center justify-center lg:flex">
        <Button
          onClick={() => setSearchMenuOpen(!searchMenuOpen)}
          intent="primary"
          className=" flex items-center justify-center rounded-e-half rounded-s-px p-2 text-white"
        >
          <SearchNormal1 variant="Broken" size={21} />
        </Button>
      </div>
    </div>
  );
}

export default SearchFelid;
