"use client";

import { Logo } from "@/src/components/Logo";
import { TextField, FormProvider } from "@/src/components/RHF";
import React, { useMemo } from "react";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as Yup from "yup";
import { useAuth } from "@/src/hooks";
import { useUrlStore } from "@/src/hooks/Extras";
import { useAuthStore } from "@/src/store";
import Button from "@/src/components/Button";

import { useSettingsStore } from "@/src/providers/SettingsProvider";
import Link from "next/link";

interface FormFields {
  mobile: string;
}

const defaultValues: FormFields = {
  mobile: "",
};

function Login() {
  const { sendActivationCode, isLoading } = useAuth();
  const { setData } = useUrlStore();
  const { setAuthUser } = useAuthStore();
  const registerSchema = useMemo(
    () =>
      Yup.object().shape({
        mobile: Yup.string()
          .matches(
            /^(098|0098|98|\+98|0)?9(0[0-5]|[1 3]\d|2[0-3]|9[0-9]|41)\d{7}$/g,
            "لطفا شماره موبایل خود را بصورت درست وارد کنید "
          )
          .required("لطفا شماره موبایل خود را بصورت درست وارد کنید "),
      }),
    // eslint-disable-next-line react-hooks/exhaustive-deps
    []
  );

  const methods = useForm<FormFields>({
    defaultValues,
    resolver: yupResolver(registerSchema),
    mode: "onChange",
  });

  const {
    handleSubmit,
    formState: { isValid },
    setError,
  } = methods;

  const onSubmit = handleSubmit(async (data) => {
    try {
      await sendActivationCode(data.mobile);

      setAuthUser({
        mobile: data.mobile,
      });
      setData("step", "verify");
    } catch (error) {
      setError("mobile", {
        type: "manual",
        message: error.data.message,
      });
      console.log(error);
    }
  });
  const { title, privacyRoute } = useSettingsStore((item) => item.settings);

  return (
    <div className="flex w-full flex-col gap-16">
      <div className="flex flex-col items-end justify-end gap-16  ">
        <Logo width={75} height={13} />
      </div>

      <FormProvider methods={methods} onSubmit={onSubmit}>
        <div className="flex flex-col  gap-8 ">
          <p className="w-full  text-right text-h2  font-bold">
            ورود یا ثبت نام
          </p>
          <div>
            <TextField
              onlyNumber
              fullWidth
              type="text"
              inputMode="numeric"
              name="mobile"
              label="شماره تلفن همراه"
              className="text-left"
            />
            <span className="text-h5 leading-6 ">
              ثبت نام در {title} به منزله پذیرش همه{` `}
              <Link
                href={privacyRoute}
                target="_blank"
                className="mx-px text-info"
              >
                قوانین و شرایط
              </Link>
              {` `}
              استفاده است.
            </span>
          </div>
          <Button disabled={!isValid} isLoading={isLoading} type="submit">
            ادامه
          </Button>
        </div>
      </FormProvider>
    </div>
  );
}

export default Login;
