import NextImg from "@/src/components/NextImage";
import { Star } from "iconsax-react";
import React from "react";

interface Props {
  cover: string;
  title: string;
  ariaTitle: string;
  rate: number;
}

function ChefCard({ title, ariaTitle, rate, cover }: Props) {
  return (
    <div className="flex h-full w-[300px] flex-col  overflow-hidden rounded-half  text-white shadow-base">
      <NextImg src={cover ?? ""} width={300} height={250} alt={title} />
      <div className="flex w-full flex-col items-center justify-center gap-1 p-2">
        {!!rate && (
          <div className="flex w-full items-center justify-end gap-1 ">
            <p className="text-h5">{rate}</p>
            <Star size="20" color="#FFB800" variant="Bold" />
          </div>
        )}
        <p className="text-h3 font-bold">
          <span className="font-normal">رستوران: </span>
          {title}
        </p>

        <p className="text-h5">محدوده ارسال: {ariaTitle}</p>
      </div>
    </div>
  );
}

export default ChefCard;
