import NextImg from "@/src/components/NextImage";
import { useCategoriesQuery } from "@/src/hooks/Queries";
import { ArrowDown2 } from "iconsax-react";
import React, { useState } from "react";

interface Props {
  onChangeCategories: (category: string) => void;
  defaultCategory?: string;
}
function ChefsSideBar({ onChangeCategories, defaultCategory }: Props) {
  const { data: categories } = useCategoriesQuery({});
  const [menuCollapse, setMenuCollapse] = useState(true);

  return (
    <div className="flex h-max w-full flex-col rounded-half  bg-white p-2 text-primary lg:max-w-xs lg:shadow-4">
      <button
        className="flex w-full  justify-between py-2 text-h3 font-bold"
        onClick={() => setMenuCollapse(!menuCollapse)}
      >
        دسته بندی های غذایی
        <ArrowDown2
          size="22"
          variant="Broken"
          className={`transition-all  duration-700 ${
            menuCollapse && "rotate-180"
          }`}
        />
      </button>
      <div
        className={`flex overflow-auto transition-max-height duration-700 ease-in-out ${
          menuCollapse ? "max-h-[600px] " : "max-h-0"
        } flex-col gap-2 overflow-hidden  `}
      >
        <button
          onClick={() => onChangeCategories("")}
          className={`w-full px-2 text-right text-h4 ${
            !defaultCategory && "font-bold"
          }`}
        >
          همه دسته بندی ها
        </button>{" "}
        {categories?.map((item) => (
          <button
            key={item.id}
            onClick={() => onChangeCategories(item.id)}
            className={`flex w-full gap-1 px-2 text-right text-h4 ${
              item.id === defaultCategory && "font-bold"
            }`}
          >
            <NextImg src={item.image} alt={item.title} width={22} height={22} />
            {item.title}
          </button>
        ))}
      </div>
    </div>
  );
}

export default ChefsSideBar;
