import ProductCard from "@/src/components/ProductCard";
import { useCartStore } from "@/src/store";
import { BaseFood } from "@/src/types/food";
import { useSnackbar } from "notistack";
import React from "react";

import FoodsLoader from "../FoodsLoader";

interface Props {
  foods: BaseFood[] | [];
  isLoading: boolean;
}

function FoodsItems({ foods, isLoading }: Props) {
  const { addToCard, removeFromCard, itemCount, chefId } = useCartStore();
  const { enqueueSnackbar } = useSnackbar();

  const handleAddCard = (product: BaseFood) => {
    if (chefId === "" || product.chefID === chefId) {
      addToCard({
        id: product.id,
        count: 1,
        price: product.price,
        title: product.title,
        varietyID: product.varietyID,
        chefID: product.chefID,
      });
      enqueueSnackbar("غذا با موفقیت به سبد خرید شما اضافه شد", {
        variant: "success",
      });
    } else
      enqueueSnackbar("شما یک سفارش باز از رستورانی دیگر دارید", {
        variant: "error",
      });
  };
  const handleRemoveCard = (id: string) => {
    enqueueSnackbar("غذا با موفقیت از سبد خرید شما کم شد", {
      variant: "success",
    });
    removeFromCard(id);
  };

  return (
    <div className="flex min-h-[600px] w-full flex-col gap-4 px-0 ">
      <div className="grid  grid-cols-1 gap-0 lg:grid-cols-2 lg:gap-3 ">
        {isLoading && <FoodsLoader />}
        {foods.map((item) => (
          <ProductCard
            discount={item.discount}
            onAddCard={() => handleAddCard(item)}
            onRemoveCard={() => handleRemoveCard(item.varietyID)}
            countInCard={itemCount(item.varietyID)}
            key={item.id}
            id={item.id}
            Summary={item.Summary}
            image={item.image}
            price={item.price}
            limit={item.maxOrderLimit}
            title={item.title}
            calory={item.calory}
          />
        ))}
      </div>
      <div className="flex items-center justify-start rounded-half bg-primary"></div>
    </div>
  );
}

export default FoodsItems;
