import React from "react";
import Skeleton from "react-loading-skeleton";

interface Props {
  count?: number;
}

function FoodsLoader({ count = 10 }: Props) {
  return Array(count)
    .fill(0)
    .map((_, index) => (
      <div key={index} className="h-[160px] w-full">
        <Skeleton className="size-full" />
      </div>
    ));
}

export default FoodsLoader;
