import { ApiComponentExtraData } from "@/src/services/httpServices/SettingsServices/types";
import Image from "next/image";
import Link from "next/link";
import React from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { SwiperOptions } from "swiper/types";
import { ClassNameValue, twMerge } from "tailwind-merge";

interface Props {
  images: ApiComponentExtraData;
  className?: ClassNameValue;

  breakpoints: SwiperOptions["breakpoints"];
}
function BannerSlider({ images, className, breakpoints }: Props) {
  return (
    <div className={twMerge(" container h-[190px] w-full lg:p-0 ", className)}>
      <Swiper loop className="size-full" breakpoints={breakpoints}>
        {images?.images?.map((item, index) => (
          <SwiperSlide
            key={item.link ?? index}
            className="overflow-hidden rounded-half"
          >
            {item?.link ? (
              <Link href={item.link}>
                <Image
                  src={item.image}
                  fill
                  alt={item.title ?? "image"}
                  className="h-full"
                />
              </Link>
            ) : (
              // render image without link
              <div className="relative h-full w-full">
                <Image
                  src={item.image}
                  fill
                  alt={item.title ?? "image"}
                  className="h-full"
                />
              </div>
            )}
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}

export { BannerSlider };
