import React from "react";

import Link from "next/link";

import { ApiComponentExtraData } from "@/src/services/httpServices/SettingsServices/types";
import { ClassNameValue, twMerge } from "tailwind-merge";
import Image from "next/image";

interface Props {
  images: ApiComponentExtraData;
  className?: ClassNameValue;
  width?: number;
  height?: number;
}

function Banners({ images, className, height = 200, width = 800 }: Props) {
  return (
    <div
      className={twMerge(
        "grid  grid-cols-1   gap-3 p-4 lg:grid-cols-2 lg:p-0",
        className
      )}
    >
      {images.images?.map((item, index) => (
        <Link
          key={index}
          href={item.link}
          className="size-full overflow-hidden rounded-base"
        >
          <Image
            src={item.image}
            className="w-full"
            width={width}
            height={height}
            alt={item.title}
          />
        </Link>
      ))}
    </div>
  );
}

export default Banners;
