import React from "react";
import { usePaginatedChefQuery } from "@/src/hooks/Queries";
import { OrderDataVariant } from "@/src/types/general";

import ChefSlider from "./ChefSlider";

interface Props {
  title: string;
  buttonText: string;
}
function BestChefSlider({ buttonText, title }: Props) {
  const { data, isLoading } = usePaginatedChefQuery({
    order: OrderDataVariant.RATE,
  });
  return (
    <>
      {!isLoading && data && (
        <ChefSlider chefs={data?.data} buttonText={buttonText} title={title} />
      )}
    </>
  );
}

export default BestChefSlider;
