import React from "react";
import image from "@/public/assets/images/icons/shape-1.svg";
import image2 from "@/public/assets/images/icons/shape-2.svg";
import Image from "next/image";
import { Logo } from "@/src/components/Logo";
import { QuoteUp } from "iconsax-react";
import { Variants, motion } from "framer-motion";

interface Props {
  title: string;

  description: string;
}
const cardVariants: Variants = {
  offscreen: {
    y: 300,
  },
  onscreen: {
    y: 0,

    transition: {
      ease: "easeInOut",

      duration: 1.25,
    },
  },
};
function Info({ description, title }: Props) {
  return (
    <motion.div
      initial="offscreen"
      whileInView="onscreen"
      viewport={{ once: true, amount: 0.2 }}
      className="my-10 flex w-full items-center justify-center lg:container"
    >
      <div className="px-3">
        <motion.div
          variants={cardVariants}
          className="relative flex items-center justify-between bg-primary  text-white"
        >
          <Image className="hidden h-full lg:block" src={image} alt="a" />
          <QuoteUp
            size="32"
            className="absolute left-6 top-4 hidden lg:block"
          />
          <div className="flex flex-col items-center justify-center gap-3 px-5 py-3 text-center">
            <h3 className="bold text-h3">{title}</h3>
            <p className="text-h4 leading-8"> {description}</p>
            <Logo width={90} height={90} />
          </div>

          <Image className="hidden h-full lg:block" src={image2} alt="a" />
        </motion.div>
      </div>
    </motion.div>
  );
}

export default Info;
