import Link from "next/link";
import React from "react";

import { Instagram, Whatsapp } from "iconsax-react";

interface Props {
  instagram?: string;

  whatsApp?: string;
}

function SocialMedia({ instagram, whatsApp }: Props) {
  return (
    <div
      className="flex items-center justify-center  gap-16
"
    >
      {instagram && (
        <Link
          prefetch={false}
          target="_blank"
          rel="nofollow noreferrer noopener"
          href={instagram}
        >
          <Whatsapp size={32} variant="Bulk" />
        </Link>
      )}
      {whatsApp && (
        <Link
          href={whatsApp}
          prefetch={false}
          target="_blank"
          rel="nofollow noreferrer noopener"
        >
          <Instagram size={32} variant="Bulk" />
        </Link>
      )}
    </div>
  );
}

export default SocialMedia;
