"use client";

import React, { useCallback } from "react";
import { useOrderQuery } from "@/src/hooks/Queries";
import { orderResultMode } from "@/src/types/general";
import OrderError from "./OrderError";
import OrderSuccess from "./OrderSuccess";
import Loader from "../Loader";
import OrderTrackingPage from "./OrderSuccess";

interface Props {
  paymentResult: boolean;
  orderId?: string;
  mode?: orderResultMode;
}

function OrderPage({ orderId, paymentResult, mode = "order" }: Props) {
  const { data, isLoading } = useOrderQuery(orderId);
 
  const RenderContent = useCallback(() => {
    switch (paymentResult) {
      case true:
        return <OrderTrackingPage order={data} />;
      case false:
        return <OrderError order={data} mode={mode} />;

      default:
        return <OrderError order={data} mode={mode} />;
    }
  }, [paymentResult, data]);
  return (
    <div className="container  py-12 ">
      {isLoading && <Loader />}
      {!isLoading && <RenderContent />}
    </div>
  );
}

export default OrderPage;
