import React, { useRef } from "react";
import { Swiper, SwiperRef, SwiperSlide } from "swiper/react";
import { Navigation } from "swiper/modules";

import { Post } from "@/src/types/Post";
import NextImg from "@/src/components/NextImage";
import Link from "next/link";

interface Props {
  data: Post[];
  isLoading: boolean;
}
function PostCategorySlider({ data, isLoading }: Props) {
  const sliderRef = useRef<SwiperRef>(null);

  return (
    <div className=" relative block w-full py-12 lg:hidden">
      {!isLoading && (
        <Swiper
          ref={sliderRef}
          navigation={true}
          modules={[Navigation]}
          className="w-full"
          spaceBetween={20}
          // loop
          breakpoints={{
            240: {
              slidesPerView: 1.2,
              spaceBetween: 10,
            },

            540: {
              slidesPerView: 3,
              spaceBetween: 10,
            },
            670: {
              slidesPerView: 5,
              spaceBetween: 20,
            },
            750: {
              slidesPerView: 6,
              spaceBetween: 20,
            },
          }}
        >
          {data?.map((post) => (
            <SwiperSlide key={post.id}>
              <Link href={`/post/${post.id}`}>
                <div className="flex flex-col items-center justify-center gap-4 border  border-black/10 ">
                  <div className=" flex w-full cursor-pointer  flex-col items-center gap-4">
                    <NextImg
                      src={post.cover}
                      width={250}
                      height={170}
                      alt={post.title}
                    />
                    <p className=" line-clamp-1 w-full truncate p-4   text-h5 font-bold">
                      {post.title}
                    </p>
                  </div>
                </div>
              </Link>
            </SwiperSlide>
          ))}
        </Swiper>
      )}
    </div>
  );
}

export default PostCategorySlider;
