"use client";

import React, { useState } from "react";

import { useQueryState, parseAsInteger } from "next-usequerystate";
import { FOODS_FILTERS } from "@/src/constants/Filters";
import { usePostsListQuery } from "@/src/hooks/Queries";
import ReactPaginate from "react-paginate";
import { ArrowLeft2, ArrowRight2 } from "iconsax-react";

import { FullScreenModal } from "@/src/components/FullScreenModal";
import ChefsItems from "./ChefsItems";
import ChefOrder from "./ChefOrder";
import PostHeader from "./PostHeader";

function PostList() {
  const [defaultCategory, setCategory] = useQueryState(FOODS_FILTERS.CATEGORY);
  const [title] = useQueryState(FOODS_FILTERS.SEARCH);
  const [page, setPage] = useQueryState(
    FOODS_FILTERS.PAGE,
    parseAsInteger.withDefault(1)
  );

  const { data: posts, isLoading } = usePostsListQuery({
    categoryID: defaultCategory ?? "",
    page,
    title: title ?? "",
  });

  const [filterMenuOpen, setFilterMenuOpen] = useState(false);

  return (
    <div className="flex w-full flex-col">
      <div className="container ">
        <div className="flex flex-col items-start justify-center gap-12 lg:gap-20">
          <PostHeader posts={posts?.data ?? []} />
          <div className=" mt-2 flex w-full items-center justify-center  lg:hidden">
            <button
              onClick={() => setFilterMenuOpen(true)}
              className="hover:text-bold flex w-full items-center justify-center whitespace-nowrap rounded-half border border-primary px-12 py-4 text-h3  text-primary transition-all  hover:bg-error-extraLight"
            >
              فیلترها
            </button>
          </div>
          <div className=" flex w-full flex-col items-center justify-center gap-12  pb-10   lg:px-0 lg:pb-20">
            <ChefsItems
              isLoading={isLoading}
              posts={posts?.data ?? []}
              onChangeCategories={(catId) => setCategory(catId)}
              defaultCategory={defaultCategory ?? ""}
            />
            <ReactPaginate
              disableInitialCallback
              className="flex h-max items-center gap-8 text-body text-white "
              previousLabel={
                <ArrowRight2
                  size="16"
                  className="text-primary"
                  variant="Broken"
                />
              }
              onPageChange={({ selected }) => {
                window.scroll({ top: 0, left: 0, behavior: "smooth" });
                setPage(selected + 1);
              }}
              pageRangeDisplayed={3}
              pageCount={posts?.totalPages ?? 0}
              nextLabel={
                <ArrowLeft2
                  size="16"
                  className="text-primary"
                  variant="Broken"
                />
              }
              renderOnZeroPageCount={() => null}
              initialPage={page - 1}
              pageClassName=" flex items-center justify-center size-12"
              activeClassName="rounded-full bg-secondary"
              forcePage={page - 1}
            />
          </div>
        </div>
      </div>
      <FullScreenModal
        title="فیلترها"
        open={filterMenuOpen}
        onClose={() => setFilterMenuOpen(false)}
      >
        <ChefOrder
          onChangeCategories={(catId) => setCategory(catId)}
          defaultCategory={defaultCategory ?? ""}
        />
      </FullScreenModal>
    </div>
  );
}

export default PostList;
