import { Heart, Hierarchy } from "iconsax-react";
import React from "react";

interface Props {
  onShare: VoidFunction;
  onFavorite: VoidFunction;
  isLiked: boolean;
}

function ProductActions({ isLiked, onFavorite, onShare }: Props) {
  return (
    <>
      <div className="flex items-center gap-2 px-2 text-hero text-white ">
        <button
          // onClick={() => mutate({ id, status: data ?? false, type: "product" })}
          onClick={onFavorite}
          className="flex items-center gap-2"
        >
          <Heart variant={isLiked ? "Bold" : "Broken"} fontSize={24} />
          <span className="hidden lg:block"> علاقه مندی ها</span>
        </button>

        <div className=" inline-block w-px  self-stretch  bg-white opacity-100"></div>
        <button onClick={onShare} className="flex items-center gap-2">
          <Hierarchy variant="Broken" fontSize={24} />
          <span className="hidden lg:block"> اشتراک گذاری</span>
        </button>
      </div>
    </>
  );
}

export default ProductActions;
