import React from "react";
import moment from "jalali-moment";
import { Comment } from "@/src/types/Comment";
import Rate from "@/src/components/Rate";

function ProductCommentCard({
  content,
  rate,
  date,
  user,
}: Omit<Comment, "products">) {
  const commentDate = moment(date).locale("fa").format("D MMM ");
  return (
    <div className="h-20 rounded-half  bg-primary p-2">
      <div className="flex justify-between">
        <div className="flex gap-1">
          <p className="text-h5">{commentDate}</p>
          <p className=" flex items-center  text-h5">
            <span
              className=" mx-1 inline-flex h-1 w-1
   items-center justify-center rounded-[50%] 
     bg-secondary font-bold "
            ></span>
            {user}
          </p>
        </div>
        <div className="flex items-center gap-1  ">
          <Rate count={rate} size={14} />
        </div>
      </div>
      <div>
        <p className="mt-2 text-h4">{content}</p>
      </div>
    </div>
  );
}

export default ProductCommentCard;
