import React, { useCallback, useRef } from "react";
import { Swiper, SwiperRef, SwiperSlide } from "swiper/react";
import { Navigation } from "swiper/modules";
import { ArrowLeft2, ArrowRight2 } from "iconsax-react";
import { useProductCommentQuery } from "@/src/hooks/Queries";
import ProductCommentCard from "../ProductCommentCard";

interface Props {
  foodId: string;
  title: string;
}
function ProductCommentsSlider({ foodId, title }: Props) {
  const sliderRef = useRef<SwiperRef>(null);

  const handlePrev = useCallback(() => {
    if (!sliderRef.current) return;
    sliderRef.current.swiper.slidePrev();
  }, []);

  const handleNext = useCallback(() => {
    if (!sliderRef.current) return;
    sliderRef.current.swiper.slideNext();
  }, []);
  const { data } = useProductCommentQuery(foodId);
  return (
    <div className="  w-full ">
      {!!data?.length && (
        <>
          <p className="mb-2 text-body">نظرات {title}</p>
          <div className="flex items-center">
            <button
              className="hidden h-5 w-3 items-center justify-center rounded-s-8  bg-secondary lg:flex "
              onClick={handlePrev}
            >
              <ArrowRight2 size="18" color="#ffffff" variant="Broken" />
            </button>
            <Swiper
              ref={sliderRef}
              navigation={true}
              modules={[Navigation]}
              slidesPerView={3}
              spaceBetween={10}
              className=" w-full"
              breakpoints={{
                240: {
                  slidesPerView: 1,
                },
                400: {
                  slidesPerView: 1,
                },
                540: {
                  slidesPerView: 2,
                },
                670: {
                  slidesPerView: 3,
                },
                890: {
                  slidesPerView: 3,
                },
                1280: {
                  slidesPerView: 3,
                },
              }}
            >
              {data?.map((item) => (
                <SwiperSlide key={item.id}>
                  <ProductCommentCard
                    content={item.content}
                    rate={item.rate}
                    id={item.id}
                    date={item.date}
                    user={item.user}
                  />
                </SwiperSlide>
              ))}
            </Swiper>

            <button
              onClick={handleNext}
              className="hidden h-5  w-3 items-center justify-center rounded-e-8  bg-secondary lg:flex "
            >
              <ArrowLeft2 size="18" color="#ffffff" variant="Broken" />
            </button>
          </div>
        </>
      )}
    </div>
  );
}

export default ProductCommentsSlider;
