import AddCardButton from "@/src/components/AddCardButton";
import LoaderSpinner from "@/src/components/LoaderSpinner";
import Rate from "@/src/components/Rate";
import { Discount } from "@/src/types/food";
import { numberWithCommas } from "@/src/utils/Helpers";
import { Hierarchy } from "iconsax-react";
import Link from "next/link";

import React from "react";

interface Props {
  chefId: string;
  energy: number;
  rate: number;
  caloriesLoading: boolean;
  statusLoading: boolean;
  onAddCart: VoidFunction;
  onRemoveCart: VoidFunction;
  onShare: VoidFunction;
  productInCart: number;
  limit?: number;
  status: boolean;
  price: Discount;
  mainPrice: number;
  isLoadingCart: boolean;
}

function ProductDataCard({
  chefId,
  energy,
  price,
  rate,
  caloriesLoading,
  statusLoading,
  status,
  mainPrice,
  onAddCart,
  onRemoveCart,
  productInCart,
  onShare,
  limit = 10,
  isLoadingCart,
}: Props) {
  return (
    <div className=" w-full rounded-half bg-primary text-white lg:max-w-xs lg:p-1">
      <div className="border-stroke-primary flex  w-full items-center justify-center gap-3 border-b pb-1">
        <Link href="/foods" className=" w-full p-2 text-right text-h4">
          همه غذاها
        </Link>
        <div className="inline-block w-px  self-stretch  bg-white opacity-100"></div>

        <Link
          href={`/chef/${chefId}`}
          className="w-full  p-2 text-right text-h4"
        >
          صفحه رستوران
        </Link>
      </div>
      {!!energy && (
        <div className="border-stroke-primary border-b p-2">
          {caloriesLoading ? (
            <LoaderSpinner className="fill-secondary" />
          ) : (
            <p className="text-body text-text-secondary">
              کالری : (kc) {energy ?? 0}
            </p>
          )}
        </div>
      )}
      <div className="border-stroke-primary border-b p-2">
        {statusLoading ? (
          <LoaderSpinner className="fill-secondary" />
        ) : (
          <p className="text-h4 ">
            {status ? "آماده ارسال" : "عدم سفارش گیری"}
          </p>
        )}
      </div>{" "}
      <div className="border-stroke-primary hidden border-b p-2 lg:block">
        <button onClick={onShare} className="flex items-center gap-1 text-h4 ">
          <Hierarchy variant="Broken" size={16} />
          اشتراک گذاری
        </button>
      </div>
      {rate && (
        <div className="border-stroke-primary flex items-center gap-1 border-b p-2">
          <Rate count={rate} size={12} />
          <p className="text-h4  text-text-secondary">{rate} از 5</p>
        </div>
      )}
      <div className="border-stroke-primary hidden items-center justify-between border-b p-2 lg:flex">
        <div>
          {price?.percent !== 0 && (
            <span className="text-h5 font-bold text-secondary line-through ">
              <span className="text-white">{mainPrice}</span>
            </span>
          )}
          <p className="text-bold text-h3">
            {numberWithCommas(price?.discountedPrice ?? 0)} تومان
          </p>
        </div>
        <AddCardButton
          isLoading={isLoadingCart}
          onAddCard={onAddCart}
          onRemoveCard={onRemoveCart}
          productInCart={productInCart}
          limit={limit}
        />
      </div>
    </div>
  );
}

export default ProductDataCard;
