import React, { useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Thumbs } from "swiper/modules";
import Image from "next/image";
import { type Swiper as SwiperRef } from "swiper";
import { File } from "@/src/types/general";
import "swiper/css/thumbs";
import LogoImg from "@/public/assets/images/default/placeholder.svg";

interface Props {
  gallery: File[];

  image: string;
}
function ProductTumbSlider({ gallery, image }: Props) {
  const [thumbsSwiper, setThumbsSwiper] = useState<SwiperRef | null>(null);

  const hasImage = !!image;
  const hasGallery = gallery.length > 0;

   return (
    <div className="flex flex-col gap-12">
      <Swiper
        modules={[Thumbs]}
        thumbs={{
          swiper: thumbsSwiper && !thumbsSwiper.destroyed ? thumbsSwiper : null,
        }}
        slidesPerView={1}
        className="size-full"
      >
        <SwiperSlide className="size-full">
          <div className=" h-[450px] w-full overflow-hidden rounded-half object-contain lg:size-[450px]  ">
            <Image
              src={hasImage ? image : LogoImg}
              alt="test"
              className="size-full object-contain"
              width={500}
              height={500}
            />
          </div>
        </SwiperSlide>
        {hasGallery &&
        gallery.map((item) => (
          <SwiperSlide key={item.id} className="size-full">
            <div className=" h-[450px] w-full overflow-hidden rounded-half object-contain lg:size-[450px]  ">
              <Image
                src={item?.path ?? ""}
                alt="test"
                width={500}
                height={500}
                className="size-full object-contain"
              />
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
      <Swiper
        modules={[Thumbs]}
        slidesPerView={4.5}
        slideToClickedSlide
        spaceBetween={20}
        watchSlidesProgress
        onSwiper={(Swipper) => setThumbsSwiper(Swipper)}
        className="h-50 w-full"
      >
        <SwiperSlide className=" overflow-hidden rounded-half ">
          <Image
            src={hasImage ? image : LogoImg}
            alt="test"
            width={100}
            height={100}
            className={`w-full  `}
          />
        </SwiperSlide>
        {hasGallery &&
        gallery.map((item) => (
          <SwiperSlide className=" overflow-hidden rounded-half " key={item.id}>
            <Image
              src={item?.path ?? ""}
              alt="test"
              width={100}
              height={100}
              className={`w-full  `}
            />
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}

export { ProductTumbSlider };
