"use client";

import React, { useEffect } from "react";
import { ProfileItems } from "@/src/types/general";
import { parseAsString, useQueryState } from "next-usequerystate";

import { useAddress, useAuth } from "@/src/hooks";
import { enqueueSnackbar } from "notistack";
import Sidebar from "./sidebar";
import ProfileTabs from "./profileTabs";
import { ApiCreateAddress } from "@/src/services/httpServices/AddressServices/types";

function ProfilePage() {
  const [activeMenu, setActiveMenu] = useQueryState(
    "profileTab",
    parseAsString.withDefault("")
  );
  const { createAddress } = useAddress();
  const { getTokenFromCookies } = useAuth();

  useEffect(() => {
    const checkAndSaveAddress = async () => {
      const token = getTokenFromCookies();
      if (token) {

        const unsavedAddress = localStorage.getItem("unsavedAddress");

        if (unsavedAddress) {
          try {
            const rawAddressData = JSON.parse(unsavedAddress);

            const addressData: ApiCreateAddress = {
              phone_number: rawAddressData.phone ?? "0000000000", // fallback example
              address: rawAddressData.address ?? "آدرس نامشخص",
              lat: rawAddressData.lat ?? "0",
              lng: rawAddressData.lng ?? "0",
              title: rawAddressData.title ?? "بدون عنوان",
              area_id: rawAddressData.area?.child
                ? rawAddressData.area.child.value
                : rawAddressData.area?.parent?.value ?? undefined,
            };

            await createAddress(addressData);

            enqueueSnackbar("آدرس با موفقیت ثبت شد", { variant: "success" });

            // Clear localStorage after successful save
            localStorage.removeItem("unsavedAddress");
          } catch (error) {
            console.error("Error saving address:", error);
            enqueueSnackbar("خطا در ثبت آدرس", { variant: "error" });
          }
        }
      }
    };

    checkAndSaveAddress();
  }, []);

  return (
    <div className="flex items-center   pb-8 lg:container">
      <div className="flex w-full gap-8  2xl:px-80 ">
        <Sidebar
          onItemClick={(id) => setActiveMenu(id)}
          activeMenu={activeMenu as ProfileItems}
        />

        <ProfileTabs
          onBack={() => setActiveMenu("")}
          activeMenu={activeMenu as ProfileItems}
        />
      </div>
    </div>
  );
}

export default ProfilePage;
