import { Address } from "@/src/types/Address";
import { Edit, Location, Trash } from "iconsax-react";
import React from "react";

interface actions {
  onEdit: VoidFunction;
  onDelete: VoidFunction;
}

function AddressCard({
  address,
  title,
  onEdit,
  onDelete,
}: Omit<Address, "id"> & actions) {
  return (
    <div className="flex flex-col gap-6 border-b border-black/20 py-10">
      <div className="flex items-center justify-between">
        <p className="text-h3 font-bold">{title}</p>
        <div className="flex items-center gap-8 text-black/60 transition-all">
          <button onClick={onEdit} className="hover:text-primary">
            <Edit size={24} />
          </button>
          <button onClick={onDelete} className="hover:text-primary">
            <Trash size={24} />
          </button>
        </div>
      </div>
      <p className="flex gap-2 text-h4  text-black/90">
        <Location size={16} className="text-primary" />
        {address}
      </p>
    </div>
  );
}

export default AddressCard;
