import { useDiscountQuery } from "@/src/hooks/Queries";
import { useCopyToClipboard } from "@uidotdev/usehooks";
import { Copy } from "iconsax-react";
import moment from "jalali-moment";
import { useSnackbar } from "notistack";
import React from "react";

function Discounts() {
  const { data, isLoading } = useDiscountQuery({
    page: 1,
  });
  const [copiedText, copyToClipboard] = useCopyToClipboard();
  const { enqueueSnackbar } = useSnackbar();
  return (
    <div className="flex py-2">
      <table className="border-stroke-primary w-full border">
        <thead>
          <tr className="border-stroke-primary *:border-stroke-primary border text-right text-h4 font-normal *:rounded-base *:border  *:px-1 *:py-2 ">
            <th>توضیحات</th>
            <th className="text-center">تاریخ انقضا</th>
            <th className="text-center">مقدار</th>
            <th>کد تخفیف</th>
          </tr>
        </thead>
        <tbody>
          {!isLoading && !data?.data.length && (
            <tr className="border-stroke-primary rounded-base border text-right">
              <td
                colSpan={4}
                className=" border-stroke-primary truncate rounded-base border  px-1 py-2 text-center text-hero font-bold"
              >
                کد تخفیف فعالی موجود نیست !
              </td>
            </tr>
          )}
          {data?.data.map((item) => (
            <tr
              key={item.title}
              className="border-stroke-primary rounded-base border text-right"
            >
              <td className=" border-stroke-primary truncate rounded-base border px-1 py-2 text-right">
                {item.title}
              </td>{" "}
              <td className=" border-stroke-primary truncate rounded-base border px-1 py-2 text-center ">
                {moment(item.expireDate).locale("fa").format("YYYY/MM/DD")}
              </td>{" "}
              <td className=" border-stroke-primary truncate rounded-base border px-1 py-2 text-center">
                % {item.percent}
              </td>
              <td className=" border-stroke-primary flex items-center justify-between border p-2 text-right">
                {item.code}
                <button
                  onClick={() => {
                    enqueueSnackbar(`کد ${copiedText} کپی شد`, {
                      variant: "success",
                    });
                    copyToClipboard(item.code);
                  }}
                >
                  <Copy fontSize={24} />
                </button>
              </td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}

export default Discounts;
