import LoaderSpinner from "@/src/components/LoaderSpinner";
import NextImg from "@/src/components/NextImage";
import Link from "next/link";
import React from "react";
import { useTranslation } from "react-i18next";

interface Props {
  logo: string;
  title: string;
  id: string;
  ariaTitle: string;
  onDelete: VoidFunction;
  isLoading: boolean;
}

function FavoriteChefCard({
  logo,
  title,
  ariaTitle,
  onDelete,
  id,
  isLoading,
}: Props) {
  const { t } = useTranslation();

  return (
    <div className="flex size-full flex-col gap-1 overflow-hidden rounded-px bg-primary text-white">
      <Link href={`/chef/${id}`}>
        <NextImg
          src={logo ?? ""}
          width={300}
          height={250}
          imgWrapperClassName="!max-w-full"
          alt={title}
        />
      </Link>
      <div className="flex w-full flex-col items-start justify-center gap-1  border border-white p-2">
        <p className="text-body font-bold">
          <span className="font-normal">{t("restaurant")}: </span>
          {title}
        </p>

        <p className="text-h5">محدوده ارسال: {ariaTitle}</p>
        <div className="flex w-full justify-end">
          <button
            onClick={onDelete}
            disabled={isLoading}
            className="flex w-1/2 items-center justify-center  rounded-base border border-secondary py-1 text-h4"
          >
            {isLoading ? <LoaderSpinner /> : "حذف"}
          </button>
        </div>
      </div>
    </div>
  );
}

export default FavoriteChefCard;
