import LoaderSpinner from "@/src/components/LoaderSpinner";
import NextImg from "@/src/components/NextImage";
import Link from "next/link";
import React from "react";

interface Props {
  title: string;
  id: string;
  calory?: number;
  description: string;
  image: string;
  onDelete: VoidFunction;
  isLoading: boolean;
}

function FavoriteProductsCard({
  description,
  image,
  title,
  calory,
  onDelete,
  isLoading,
  id,
}: Props) {
  return (
    <div className="flex flex-col gap-2 rounded-half bg-primary p-2 shadow-base">
      <Link href={`/product/${id}`}>
        <div className="flex w-full items-center justify-center p-1">
          <NextImg
            src={image}
            width={160}
            height={160}
            imgWrapperClassName="rounded-base overflow-hidden"
            alt={title}
          />
        </div>
      </Link>
      <div className="flex w-full flex-col gap-1">
        <p className="text-h3 ">{title}</p>
        <p className="w-3/4 truncate text-h5 text-text-secondary">
          {description}
        </p>
      </div>
      <div className="border-stroke-primary flex w-full items-center justify-between border-b pb-2">
        {/* <div className="flex  items-center gap-1 text-h5">
          <NextImg
            src=""
            width={22}
            height={22}
            imgWrapperClassName="rounded-full overflow-hidden"
            alt=""
          />
          نواب ابراهیمی
        </div> */}
        {/* <div>
          {discount?.percent !== 0 && (
          <span className="text-h5 font-light text-secondary line-through ">
            <span className="text-white">{250000}</span>
          </span>
          )}
          <p className="text-h4 font-bold">
            {numberWithCommas(260000)}{" "}
            <span className="text-h6 font-normal">تومان</span>
          </p>
        </div> */}
        {calory && <p className="text-h5">کالری : (kc) {calory}</p>}
      </div>
      <div className="flex w-full justify-end">
        <button
          onClick={onDelete}
          disabled={isLoading}
          className="flex w-1/2 items-center justify-center  rounded-base border border-secondary py-1 text-h4"
        >
          {isLoading ? <LoaderSpinner /> : "حذف"}
        </button>
      </div>
    </div>
  );
}

export default FavoriteProductsCard;
