import { Heart } from "iconsax-react";
import React from "react";
import { parseAsString, useQueryState } from "next-usequerystate";

import { FavoriteType } from "@/src/types/Favorite";
import OrderHeader from "./FavoritesHeader";
import FavoriteTabs from "./FavoritesTabs";

function Favorites() {
  const [activeMenu, setActiveMenu] = useQueryState(
    "favoriteTab",
    parseAsString.withDefault("product")
  );
  return (
    <div className="flex flex-col ">
      <div className="flex w-full gap-2 ">
        <Heart variant="Broken" />
        <p className="text-h3 text-white ">علاقه مندی ها</p>
      </div>
      <div>
        <OrderHeader
          onItemClick={(id) => setActiveMenu(id)}
          activeTap={activeMenu as FavoriteType}
        />
      </div>
      <FavoriteTabs activeTab={activeMenu as FavoriteType} />
    </div>
  );
}

export default Favorites;
