import { TicketItem } from "@/src/types/ticket";
import { convertLocalTicketStatusToPersian } from "@/src/utils/Helpers";
import { Eye } from "iconsax-react";
import React from "react";

interface Props {
  data?: TicketItem[];
  onClickItem: (id: string) => void;
  isLoading: boolean;
}
function TicketList({ data, onClickItem, isLoading }: Props) {
  return (
    <div className="flex py-8">
      <table className="w-full border border-black/20">
        <thead>
          <tr className="border border-black/20  text-right ">
            <th className="rounded-base  border border-black/20 p-8">موضوع</th>
            <th className="rounded-base  border border-black/20 p-8">وضعیت</th>
          </tr>
        </thead>
        <tbody>
          {!isLoading && !data?.length && (
            <tr className="rounded-base border border-black/20 text-right">
              <td
                colSpan={4}
                className=" truncate rounded-base border border-black/20  px-4 py-8 text-center text-hero font-bold"
              >
                هنوز تیکت ثبت نکرده اید !
              </td>
            </tr>
          )}
          {data &&
            data.map((item) => (
              <tr
                key={item.id}
                className="rounded-base border border-black/20 text-right"
              >
                <td className="max-w-20 truncate rounded-base border border-black/20 px-4 py-8 text-right">
                  {item.title} , {item.categoryTitle}
                </td>
                <td className="flex justify-between rounded-base border border-black/20 px-4 py-8  text-right">
                  {convertLocalTicketStatusToPersian(item.status)}
                  <button onClick={() => onClickItem(item.id)}>
                    <Eye />
                  </button>
                </td>
              </tr>
            ))}
        </tbody>
      </table>
    </div>
  );
}

export default TicketList;
