import { useCopyToClipboard } from "@uidotdev/usehooks";
import { Copy, CopySuccess } from "iconsax-react";
import { useSnackbar } from "notistack";
import React from "react";

interface Props {
  code: string;
}
function InviteCode({ code }: Props) {
  const [copiedText, copyToClipboard] = useCopyToClipboard();
  const { enqueueSnackbar } = useSnackbar();
  return (
    <div className="flex  w-[300px]  flex-col items-center justify-center gap-3">
      <p className="w-full text-right text-h4 text-gray-250">
        ارسال کد معرف به دوستانتان!
      </p>
      <div className="border-stroke-primary flex w-full items-center  justify-between rounded-base border">
        <p className="w-full px-1 text-left">{code}</p>
        <button
          onClick={() => {
            enqueueSnackbar("کد کپی شد", { variant: "success" });
            copyToClipboard(code);
          }}
          className="border-stroke-primary  flex items-center justify-center border p-2 text-white "
        >
          {copiedText ? (
            <>
              <CopySuccess fontSize={16} />
            </>
          ) : (
            <>
              <Copy fontSize={16} />
            </>
          )}
        </button>
      </div>
    </div>
  );
}

export default InviteCode;
