import { Icon } from "iconsax-react";
import React, { ReactNode } from "react";

interface Props {
  title: string;
  icon: ReactNode | Icon;
  onClick: VoidFunction;
  isActive: boolean;
  description?: string;
  showBorder?: boolean;
}
function SidebarItem({
  icon,
  onClick,
  title,
  isActive,
  description,
  showBorder = true,
}: Props) {
  return (
    <li
      className={`flex items-center justify-between ${
        showBorder && "border-b"
      } border-black/20`}
    >
      <button
        onClick={onClick}
        className={`flex gap-4   ${isActive && "font-bold text-primary"}   p-8 `}
      >
        {icon as ReactNode}
        <p className="text-h3 ">{title}</p>
      </button>
      <p className="text-h5 text-text-secondary">{description}</p>
    </li>
  );
}

export default SidebarItem;
