import React from "react";
import { useChefCommentQuery } from "@/src/hooks/Queries";

import LoaderSpinner from "@/src/components/LoaderSpinner";
import ChefCommentCard from "../SingleRestaurantCommentCard";

interface Props {
  chefID: string;
}
function SingleRestaurantComments({ chefID }: Props) {
  const { data, isLoading } = useChefCommentQuery(chefID);
  return !isLoading ? (
    <>
      {!!data?.comments.length && (
        <div id="comments" className="  flex w-full flex-col gap-4 py-4 ">
          <p className="text-h3 font-bold ">نظرات کاربران</p>
          <div className="grid grid-cols-1 lg:grid-cols-2">
            {data?.comments.map((item) => (
              <ChefCommentCard
                date={item.date}
                key={item.id}
                content={item.content}
                products={item.products}
                rate={item.rate}
              />
            ))}
          </div>
        </div>
      )}
    </>
  ) : (
    <LoaderSpinner />
  );
}

export default SingleRestaurantComments;
