import React from "react";
import { Swiper, SwiperSlide } from "swiper/react";

import Image from "next/image";
import { useChefGalleryQuery } from "@/src/hooks/Queries";
import Link from "next/link";

interface Props {
  chefID: string;
}

function SingleRestaurantGallery({ chefID }: Props) {
  const { data } = useChefGalleryQuery(chefID);

  return (
    <div className="  w-full  ">
      {data && (
        <Swiper
          slidesPerView={5}
          loop
          spaceBetween={15}
          breakpoints={{
            240: {
              slidesPerView: 1.25,
            },
            400: {
              slidesPerView: 2,
            },
            540: {
              slidesPerView: 3,
            },
            670: {
              slidesPerView: 4,
            },
            900: {
              slidesPerView: 5,
            },
          }}
          className=" w-full"
        >
          {data?.map((item) => (
            <SwiperSlide key={item.id}>
              <Link target="_blank" href={item.path}>
                <Image
                  src={item.path}
                  alt="test"
                  width={250}
                  height={250}
                  className="rounded-half"
                />
              </Link>
            </SwiperSlide>
          ))}
        </Swiper>
      )}
    </div>
  );
}

export default SingleRestaurantGallery;
