import React from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { twMerge } from "tailwind-merge";
import { CategoriesFood } from "@/src/types/food";

interface Props {
  wrapperClassName?: string;
  data: CategoriesFood[];
  activeId?: string;
}

function CategorySlider({ wrapperClassName, data, activeId }: Props) {
  return (
    <div className={twMerge("z-20 w-full", wrapperClassName)}>
      {data && (
        <Swiper
          spaceBetween={8}
          breakpoints={{
            240: {
              slidesPerView: 2.5,
              spaceBetween: 8,
            },
            400: {
              slidesPerView: 2.5,
            },
            540: {
              slidesPerView: 3,
            },
            670: {
              slidesPerView: 5,
            },
            1800: {
              slidesPerView: 10,
            },
          }}
          className="w-full"
        >
          {data?.map((item) => (
            <SwiperSlide key={item.id} className="max-w-fit">
              <button
                onClick={() => {
                  const element = document.querySelector(`#menu_${item.id}`);

                  if (element) {
                    element.scrollIntoView({
                      behavior: "smooth",
                      block: "center",
                    });
                  }
                }}
                key={item.id}
                className={twMerge(
                  "whitespace-nowrap rounded-[6px] px-3 py-2 text-h5 transition-colors",
                  activeId === `item_${item.id}`
                    ? "bg-[rgb(255_253_116/1)] font-bold text-[#0a0aa8] shadow-sm"
                    : "text-[#0a0aa8]/80 hover:bg-[rgb(255_253_116/0.55)]"
                )}
              >
                {item.title}
              </button>
            </SwiperSlide>
          ))}
        </Swiper>
      )}
    </div>
  );
}

export default CategorySlider;
