import React from "react";

import { ChefDetail } from "@/src/types/Chef";
import {
  getChefAvailableNowService,
  getChefService,
} from "@/src/services/httpServices/ChefService";
import { notFound } from "next/navigation";
import { cookies } from "next/headers";

import SingleRestaurantContents from "./SingleRestaurantContents";

interface PageProps {
  id: string;
}
async function SingleRestaurant({ id }: PageProps) {
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const data = await getChefService(id, token?.value ?? "").catch((error) => {
    notFound();
  });
  const availableResult = await getChefAvailableNowService(id);
  const chefData: ChefDetail = {
    address: data.address,
    description: data.description,
    id: data.id,
    lat: data.lat,
    lng: data.lng,
    minOrderPrice: data.min_order,
    title: data.title,
    logo: data.logo,
    rate: +data.rate,
    minOrder: +data.min_order,
    cover: data.cover,
    ariaTitle: data.area?.title || '',
    hasPreOrder: data.per_order_status,
    nearestOpeningTime:
      data.nearest_opening_hour !== null
        ? {
            title: data.nearest_opening_hour?.week_day ?? "",
            time: [
              {
                from: data.nearest_opening_hour?.from_time ?? "",
                to: data.nearest_opening_hour?.to_time ?? "",
              },
            ],
          }
        : null,
  };
  const available =
    availableResult !== null && data.status.toLowerCase() === "active";

  return <SingleRestaurantContents chefData={chefData} available={available} />;
}

export default SingleRestaurant;
