"use client";

import Link from "next/link";
import React from "react";
import { ApiPage } from "../../services/httpServices/SettingsServices/types";
import Header from "../Layouts/Header";

interface Props {
  pageData: ApiPage;
}

function StaticPages({ pageData }: Props) {
  return (
    <div>
      <div
        className="flex h-[55vh] w-full flex-col justify-between bg-staticPages bg-cover bg-center  bg-no-repeat "
        style={{
          ...(pageData.cover && {
            backgroundImage: `url(${pageData.cover})`,
          }),
        }}
      >
        <Header />
        <span />
        <div className="container w-full bg-staticLinear  py-8  backdrop-blur-md ">
          <div className="flex items-center justify-center gap-4  text-h3 lg:justify-normal ">
            <Link href="/">صفحه اصلی</Link>/
            <p className="font-bold ">{pageData.title}</p>
          </div>
        </div>
      </div>
      <div className="container flex w-full flex-col   gap-12 break-words  py-20">
        <h1 className="text-iconSm font-bold"> {pageData.title}</h1>

        <div dangerouslySetInnerHTML={{ __html: pageData.text }} />
      </div>
    </div>
  );
}

export default StaticPages;
