import { useQuery } from "@tanstack/react-query";
import { useAddress } from "../UseAddress";

function useAddressQuery(params?: {
  address_title?: string;
  address_area?: string;
}) {
  const { getUserAddress } = useAddress();

  return useQuery({
    queryKey: ["userAddressList", params?.address_area, params?.address_title],
    queryFn: () => getUserAddress(params),
    staleTime: Infinity,
  });
}

export default useAddressQuery;
