import { useQuery } from "@tanstack/react-query";
import { useCart } from "../UseCart";

type UseAreaManagementAddressQueryProps = {
  branchId?: string;
  addressId?: string;
  lat?: string;
  lng?: string;
};

function useAreaManagementAddressQuery({
  branchId,
  addressId,
  lat,
  lng,
}: UseAreaManagementAddressQueryProps) {
  const { setAddress } = useCart();

  const queryData = useQuery({
    queryKey: ["getAreaManagementAddress", branchId, addressId, lat, lng],
    queryFn: () => {
      const payload: {
        branch_id: string;
        lat?: string;
        lng?: string;
        address_id?: string;
      } = {
        branch_id: branchId!,
        lat,
        lng,
      };

      if (addressId) {
        payload.address_id = addressId;
      }

      return setAddress(payload);
    },

    enabled: !!branchId, // only run when both values exist
    staleTime: Infinity,
  });

  return queryData;
}

export default useAreaManagementAddressQuery;
