// src/hooks/query/UseChefCenterQuery.ts
"use client";
import { useQuery } from "@tanstack/react-query";
import { useChefs } from "../UseChefs";

export default function UseChefCenterQuery(chefID?: string | number) {
  const { getChefCenter } = useChefs();

  return useQuery({
    queryKey: ["chefCenter", String(chefID ?? "")],
    enabled: !!chefID,
    queryFn: () => getChefCenter(String(chefID)),
    staleTime: Infinity,
  });
}
