import { useQuery } from "@tanstack/react-query";
import { useComments } from "../UseComments";

function UseChefCommentQuery(chefID: string) {
  const { getChefComments, getChefRate } = useComments();
  const fetcher = async () => {
    const [comments, rate] = await Promise.all([
      getChefComments(chefID),
      getChefRate(chefID),
    ]);
    return {
      comments,
      rate,
    };
  };
  const queryData = useQuery({
    queryKey: ["chefCommentsList", chefID],
    queryFn: () => fetcher(),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseChefCommentQuery;
