import { useQuery } from "@tanstack/react-query";
import { useChefs } from "../UseChefs";

function UseChefPerOrderTimesQuery(chefID: string) {
  const { getChefPreOrderTimes } = useChefs();

  const queryData = useQuery({
    queryKey: ["ChefPerOrders", chefID],
    queryFn: () => getChefPreOrderTimes(chefID),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseChefPerOrderTimesQuery;
