import { useMutation, useQuery, useQueryClient } from "@tanstack/react-query";
import { FavoriteMutationType, FavoriteType } from "@/src/types/Favorite";

import { useFavorite } from "../UseFavorite";

function UseFavoriteQuery(type: FavoriteType, id: string) {
  const { favoriteStatus, addFavorite, removeFavorite } = useFavorite();
  const queryKey = ["favoriteStatus", type, id];

  const favoriteToggleFunction = (params: FavoriteMutationType) => {
    switch (params.status) {
      case false:
        return addFavorite(params.type, params.id);
      case true:
        return removeFavorite(params.type, params.id);

      default:
        return addFavorite(params.type, params.id);
    }
  };

  const queryClient = useQueryClient();

  const FavoriteMutationData = useMutation({
    mutationKey: ["favoriteStatusToggle"],
    networkMode: "always",
    mutationFn: (postParams: FavoriteMutationType) =>
      favoriteToggleFunction(postParams),
    onMutate: async (postParams: FavoriteMutationType) => {
      await queryClient.cancelQueries({ queryKey });
      const previousData = queryClient.getQueryData(queryKey);
      queryClient.setQueryData(queryKey, (prevStatus: boolean) => !prevStatus);
      return { previousData, postParams };
    },

    onError: (err, postParams, context) => {
      queryClient.setQueryData(queryKey, context?.previousData);
    },
  });

  const queryData = useQuery({
    queryKey: ["favoriteStatus", type, id],
    queryFn: () => favoriteStatus(type, id),
    staleTime: Infinity,
  });

  return { queryData, FavoriteMutationData };
}

export default UseFavoriteQuery;
